
/**************************************************************
 Metodo      : TblColOrder
 Diseo      : Bruno Capuano
 Programo    : Bruno Capuano
 Fecha       : 28 de mayo del 2001
 Version     : 2001.0.1

 Descripcion : Ordena las filas de una Tabla en base al contenido de
   las celdas de la misma, en orden Ascendete o Descendente.
 Parametros  :
     pTableId - Id de la Tabla a ordenar, 
     pColId   - Id de la columna a ordenar.
***************************************************************/

function TblColOrder(pTableId, pColId){
	var dRowCount, I, X;
	var TRi, TDi, TRx, TDx;
	var bOrder, bMove;
	var sTDiinnerText, sTDxinnerText;
	var oTable;
		
	// Busca la Tabla
	oTable=document.all.item(pTableId)
		
	dRowCount = oTable.rows.length;

	//defino el orden
	TRi = oTable.rows.item(0);		
	TDi = TRi.cells.item(pColId);
	bOrder = TDi.Order;	

	// i
	for (var i = 1; i <= dRowCount - 1; i++){
			
		// busqueda de la celda(I)
		TRi = oTable.rows.item(i);
		TDi = TRi.cells.item(pColId);
			
		// x
		for (var x = 1; x <= dRowCount - 1; x++){
			// busqueda de la celda(X)
			TRx = oTable.rows.item(x);
			TDx = TRx.cells.item(pColId);
			sTDiinnerText=TDi.innerText;
			sTDxinnerText=TDx.innerText;		
			sTDiinnerText=sTDiinnerText.toLowerCase();
			sTDxinnerText=sTDxinnerText.toLowerCase();
			bMove = false;
				
			// defino la comparacion para el ordenamiento
			if (bOrder=='true'){					
				if (sTDiinnerText>sTDxinnerText){
					bMove=true; }
				}
			else {
				if (sTDiinnerText<sTDxinnerText){
					bMove=true; }
				}				
				
			// muevo las celdas y refresco los objetos
			if (bMove==true){
				oTable.moveRow(i, x);
				TRi = oTable.rows.item(i);
				TDi = TRi.cells.item(pColId);
				TRx = oTable.rows.item(x);
				TDx = TRx.cells.item(pColId);
			}
				
		} // x
			
	}// i

	//defino el orden
	TRi = oTable.rows.item(0);
	TDi = TRi.cells.item(pColId);
	if (TDi.Order=='true')
		{TDi.Order='false'}
	else
		{TDi.Order='true'}
	//refresco la tabla
	oTable.refresh();
}
/**************************************************************
***************************************************************/

/**************************************************************
 Metodo      : TblColOrderHeader
 Diseo      : Bruno Capuano
 Programo    : Bruno Capuano
 Fecha       : 28 de mayo del 2001
 Version     : 2001.0.1

 Descripcion : Asigna una imagen a una cabecera de una columna
     segun el orden q tenga la misma.
 Parametros  :
     pTableId - Id de la Tabla a ordenar, 
     pColId   - Id de la columna a ordenar.
***************************************************************/
function TblColOrderHeader(pTableId, pColId){
	var TRi, TDi, oTable;
		
	// Busca la Tabla
	oTable=document.all.item(pTableId)	
	TRi = oTable.rows.item(0);
	TDi = TRi.cells.item(pColId);
	
	// Define la imagen en la columna de ordenamiento
	if (TDi.Order!='true')
		{	
			if (document.all.item('col' + pColId + 'Img')) {
				document.all.item('col' + pColId + 'Img').src='<%=Application("SiteLocation")%>Images/OrderDown8.gif';
			}
		}
	else
		{	
			if (document.all.item('col' + pColId + 'Img')){
				document.all.item('col' + pColId + 'Img').src='<%=Application("SiteLocation")%>Images/OrderUp8.gif';
			}
		}

	// Borra las demas imagenes
	for (var x = 0 ; x < TRi.cells.length - 1; x++){
		//alert(x);
		if (x!=pColId){
			if (document.all.item('col' + x + 'Img')){
			document.all.item('col' + x + 'Img').src='<%=Application("SiteLocation")%>Images/OrderNo8.gif';
			}
			}
	}		
}
/**************************************************************
***************************************************************/

